using System; 
using System.Diagnostics;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.Data.SqlClient;

namespace SP_With_Output_Parms
{
	/// <summary>
	/// Summary description for Form1.
	/// </summary>
    public class Form1 : System.Windows.Forms.Form
    {

        private SqlConnection cn;
        private SqlDataAdapter da;
        private SqlCommand sc; 
        private DataSet ds; 
        private SqlParameter parm; 

        internal System.Windows.Forms.Label Label4;
        internal System.Windows.Forms.Label lblMaxPrice;
        internal System.Windows.Forms.TextBox txtTitleWanted;
        internal System.Windows.Forms.Label Label1;
        internal System.Windows.Forms.Button btnFind;
        internal System.Windows.Forms.DataGrid DataGrid1;
        internal System.Windows.Forms.Label lblMinPrice;
        internal System.Windows.Forms.Label lblAvgPrice;
        internal System.Windows.Forms.Label Label5;
        internal System.Windows.Forms.Label lbl1;
        internal System.Windows.Forms.Label lblRows;
        internal System.Windows.Forms.Label Label3;
        internal System.Windows.Forms.Label label6;
        internal System.Windows.Forms.Label lblReturnValue;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

        public Form1()
        {
            try
            {

                //
                // Required for Windows Form Designer support
                //
                InitializeComponent();

                //
                // TODO: Add any constructor code after InitializeComponent call
                //
                
                // Create a connection object  
                cn = new SqlConnection("data source=.;database=biblio;uid=admin;pwd=pw");
                
                // Create a (stored procedure) SqlCommand, Add (and configure) the Parameters

                sc = new SqlCommand("TestInOutRowset",cn);
                sc.CommandType = CommandType.StoredProcedure;

                // Here's the @ReturnValue Parameter
                parm = new SqlParameter("@ReturnValue",SqlDbType.Int);
                parm.Direction = ParameterDirection.ReturnValue;

                sc.Parameters.Add(parm);
                sc.Parameters.Add("@TitleWanted", SqlDbType.VarChar, 20); //Input Parameter
                sc.Parameters.Add("@TitlesFound", SqlDbType.Int).Direction = ParameterDirection.Output;
                sc.Parameters.Add("@MaxPriceFound", SqlDbType.SmallMoney).Direction = ParameterDirection.Output;
                sc.Parameters.Add("@MinPriceFound", SqlDbType.SmallMoney).Direction = ParameterDirection.Output;
                sc.Parameters.Add("@AvgPriceFound", SqlDbType.SmallMoney).Direction = ParameterDirection.Output;
                sc.Parameters["@AvgPriceFound"].Precision = 2;

                // Create a new SqlDataAdapter initializing with the prepared SelectCommand 
                da = new SqlDataAdapter(sc);
                
                // Create a new DataSet
                ds = new DataSet();


                
                // This is just a debugging piece of code to dump the parameters to the Debug Device window...
                foreach ( SqlParameter sparm in sc.Parameters) 
                {

                    Debug.WriteLine(parm.ParameterName.ToString() + ", " +
                        sparm.Direction.ToString() + ", " +
                        sparm.SqlDbType.ToString());
                }


            }
            catch(Exception ex)
            {
                Debug.WriteLine(ex.ToString());
            }

        }

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
            this.Label4 = new System.Windows.Forms.Label();
            this.lblMaxPrice = new System.Windows.Forms.Label();
            this.txtTitleWanted = new System.Windows.Forms.TextBox();
            this.Label1 = new System.Windows.Forms.Label();
            this.btnFind = new System.Windows.Forms.Button();
            this.DataGrid1 = new System.Windows.Forms.DataGrid();
            this.lblMinPrice = new System.Windows.Forms.Label();
            this.lblAvgPrice = new System.Windows.Forms.Label();
            this.Label5 = new System.Windows.Forms.Label();
            this.lbl1 = new System.Windows.Forms.Label();
            this.lblRows = new System.Windows.Forms.Label();
            this.Label3 = new System.Windows.Forms.Label();
            this.lblReturnValue = new System.Windows.Forms.Label();
            this.label6 = new System.Windows.Forms.Label();
            ((System.ComponentModel.ISupportInitialize)(this.DataGrid1)).BeginInit();
            this.SuspendLayout();
            // 
            // Label4
            // 
            this.Label4.Location = new System.Drawing.Point(24, 288);
            this.Label4.Name = "Label4";
            this.Label4.Size = new System.Drawing.Size(136, 16);
            this.Label4.TabIndex = 16;
            this.Label4.Text = "Max Price";
            this.Label4.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
            // 
            // lblMaxPrice
            // 
            this.lblMaxPrice.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
            this.lblMaxPrice.Location = new System.Drawing.Point(200, 280);
            this.lblMaxPrice.Name = "lblMaxPrice";
            this.lblMaxPrice.Size = new System.Drawing.Size(152, 24);
            this.lblMaxPrice.TabIndex = 13;
            // 
            // txtTitleWanted
            // 
            this.txtTitleWanted.Location = new System.Drawing.Point(200, 216);
            this.txtTitleWanted.Name = "txtTitleWanted";
            this.txtTitleWanted.Size = new System.Drawing.Size(304, 20);
            this.txtTitleWanted.TabIndex = 9;
            this.txtTitleWanted.Text = "Hi%";
            // 
            // Label1
            // 
            this.Label1.Location = new System.Drawing.Point(16, 216);
            this.Label1.Name = "Label1";
            this.Label1.Size = new System.Drawing.Size(160, 24);
            this.Label1.TabIndex = 8;
            this.Label1.Text = "Title wanted (with %)";
            this.Label1.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
            // 
            // btnFind
            // 
            this.btnFind.Location = new System.Drawing.Point(400, 360);
            this.btnFind.Name = "btnFind";
            this.btnFind.Size = new System.Drawing.Size(72, 32);
            this.btnFind.TabIndex = 7;
            this.btnFind.Text = "Find";
            this.btnFind.Click += new System.EventHandler(this.btnFind_Click);
            // 
            // DataGrid1
            // 
            this.DataGrid1.DataMember = "";
            this.DataGrid1.Dock = System.Windows.Forms.DockStyle.Top;
            this.DataGrid1.HeaderForeColor = System.Drawing.SystemColors.ControlText;
            this.DataGrid1.Name = "DataGrid1";
            this.DataGrid1.Size = new System.Drawing.Size(512, 216);
            this.DataGrid1.TabIndex = 6;
            // 
            // lblMinPrice
            // 
            this.lblMinPrice.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
            this.lblMinPrice.Location = new System.Drawing.Point(200, 312);
            this.lblMinPrice.Name = "lblMinPrice";
            this.lblMinPrice.Size = new System.Drawing.Size(152, 24);
            this.lblMinPrice.TabIndex = 12;
            // 
            // lblAvgPrice
            // 
            this.lblAvgPrice.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
            this.lblAvgPrice.Location = new System.Drawing.Point(200, 344);
            this.lblAvgPrice.Name = "lblAvgPrice";
            this.lblAvgPrice.Size = new System.Drawing.Size(152, 24);
            this.lblAvgPrice.TabIndex = 10;
            // 
            // Label5
            // 
            this.Label5.Location = new System.Drawing.Point(24, 320);
            this.Label5.Name = "Label5";
            this.Label5.Size = new System.Drawing.Size(136, 16);
            this.Label5.TabIndex = 17;
            this.Label5.Text = "Min Price";
            this.Label5.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
            // 
            // lbl1
            // 
            this.lbl1.Location = new System.Drawing.Point(24, 352);
            this.lbl1.Name = "lbl1";
            this.lbl1.Size = new System.Drawing.Size(136, 16);
            this.lbl1.TabIndex = 15;
            this.lbl1.Text = "Avg Price";
            this.lbl1.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
            // 
            // lblRows
            // 
            this.lblRows.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
            this.lblRows.Location = new System.Drawing.Point(200, 248);
            this.lblRows.Name = "lblRows";
            this.lblRows.Size = new System.Drawing.Size(152, 24);
            this.lblRows.TabIndex = 11;
            // 
            // Label3
            // 
            this.Label3.Location = new System.Drawing.Point(24, 256);
            this.Label3.Name = "Label3";
            this.Label3.Size = new System.Drawing.Size(136, 16);
            this.Label3.TabIndex = 14;
            this.Label3.Text = "Rows";
            this.Label3.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
            // 
            // lblReturnValue
            // 
            this.lblReturnValue.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
            this.lblReturnValue.Location = new System.Drawing.Point(200, 376);
            this.lblReturnValue.Name = "lblReturnValue";
            this.lblReturnValue.Size = new System.Drawing.Size(152, 24);
            this.lblReturnValue.TabIndex = 18;
            // 
            // label6
            // 
            this.label6.Location = new System.Drawing.Point(24, 384);
            this.label6.Name = "label6";
            this.label6.Size = new System.Drawing.Size(136, 16);
            this.label6.TabIndex = 19;
            this.label6.Text = "Return Value (DataRows)";
            this.label6.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
            // 
            // Form1
            // 
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.ClientSize = new System.Drawing.Size(512, 413);
            this.Controls.AddRange(new System.Windows.Forms.Control[] {
                                                                          this.lblReturnValue,
                                                                          this.label6,
                                                                          this.Label4,
                                                                          this.lblMaxPrice,
                                                                          this.txtTitleWanted,
                                                                          this.Label1,
                                                                          this.btnFind,
                                                                          this.DataGrid1,
                                                                          this.lblMinPrice,
                                                                          this.lblAvgPrice,
                                                                          this.Label5,
                                                                          this.lbl1,
                                                                          this.lblRows,
                                                                          this.Label3});
            this.Name = "Form1";
            this.Text = "Form1";
            ((System.ComponentModel.ISupportInitialize)(this.DataGrid1)).EndInit();
            this.ResumeLayout(false);

        }
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new Form1());
		}

        private void btnFind_Click(object sender, System.EventArgs e)
        {
            try
            {
                // Clear the DataSet
                ds.Clear();

                // Assign the Input Parameter to pass for the Stored Procedure
                sc.Parameters["@TitleWanted"].Value = txtTitleWanted.Text;

                // Populate the DataSet
                da.Fill(ds);
            
                // Populate the DataGrid
                DataGrid1.DataSource = ds.Tables[0];
            
                // Populate the controls with output parameters (and Return Value) from the Stored Procedure
                lblRows.Text = sc.Parameters["@TitlesFound"].Value.ToString();
                lblMaxPrice.Text = sc.Parameters["@MaxPriceFound"].Value.ToString();
                lblMinPrice.Text = sc.Parameters["@MinPriceFound"].Value.ToString();
                lblAvgPrice.Text = sc.Parameters["@AvgPriceFound"].Value.ToString();
                lblReturnValue.Text = sc.Parameters["@ReturnValue"].Value.ToString();
            }
            catch(Exception ex)
            {
                Debug.WriteLine(ex.ToString());
            }
        }
	}
}
